#ifndef PROBS_HPP
#define PROBS_HPP

#include <cmath>
#include "ustate.hpp"
#include "gsl/gsl_sf_gamma.h"

void probs(double* out,const double*t,const std::vector<double>& pars,const int *n);

struct details
{
  std::vector<double> pars,npars;
  target tt;
  alt ff;
  double totaltime;

  void print(std::ostream&os=std::cerr)
  {
    for(int i=0;i<npars.size();++i)
      os<<npars[i]<<"\t";
    for(int i=0;i<pars.size();++i)
      os<<pars[i]<<"\t";
    os<<tt<<"\t";
    os<<ff<<"\t"<<totaltime;
  }
};



#endif
